/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.Log;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

class LogMonitorFrame
extends Frame
implements ActionListener,
ItemListener {
    Panel panel;
    Label logFileLabel;
    TextField logFileField;
    CheckboxGroup cBoxGroup;
    Checkbox started;
    Checkbox stopped;
    Button setFileButton;
    Insets insets = new Insets(40, 10, 10, 10);

    public LogMonitorFrame() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setTitle("Log Monitor");
        this.panel = new Panel();
        this.panel.setLayout(gridBagLayout);
        ((Component)this).setBackground(Color.white);
        this.add("Center", this.panel);
        this.logFileLabel = new Label("LogFile", 2);
        this.logFileLabel.setLocation(15, 30);
        this.panel.add(this.logFileLabel);
        gridBagConstraints = this.constraints(0, 0, 1, 1);
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.33;
        gridBagLayout.setConstraints(this.logFileLabel, gridBagConstraints);
        this.logFileField = new TextField();
        this.logFileField.setColumns(30);
        this.panel.add(this.logFileField);
        gridBagConstraints = this.constraints(1, 0, 1, 1);
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.33;
        gridBagLayout.setConstraints(this.logFileField, gridBagConstraints);
        this.setFileButton = new Button("Set");
        this.setFileButton.addActionListener(this);
        this.panel.add(this.setFileButton);
        gridBagConstraints = this.constraints(2, 0, 1, 1);
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.33;
        gridBagLayout.setConstraints(this.setFileButton, gridBagConstraints);
        this.cBoxGroup = new CheckboxGroup();
        this.started = new Checkbox("Start", Log.getLog().getLoggingState(), this.cBoxGroup);
        this.started.addItemListener(this);
        this.started.setBackground(Color.white);
        this.panel.add(this.started);
        gridBagConstraints = this.constraints(0, 1, 3, 1);
        gridBagConstraints.weighty = 0.33;
        gridBagLayout.setConstraints(this.started, gridBagConstraints);
        this.stopped = new Checkbox("Stop", !Log.getLog().getLoggingState(), this.cBoxGroup);
        this.stopped.setBackground(Color.white);
        this.panel.add(this.stopped);
        this.stopped.addItemListener(this);
        gridBagConstraints = this.constraints(0, 2, 3, 1);
        gridBagConstraints.weighty = 0.33;
        gridBagLayout.setConstraints(this.stopped, gridBagConstraints);
        this.updateFields();
        this.pack();
        this.show();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Log.getLog().setLoggingState(this.started.getState());
    }

    private synchronized void updateFields() {
        if (Log.getLog().getLoggingState()) {
            this.cBoxGroup.setSelectedCheckbox(this.started);
        } else {
            this.cBoxGroup.setSelectedCheckbox(this.stopped);
        }
        String string = Log.getLog().getFilename();
        if (string != null) {
            ((TextComponent)this.logFileField).setText(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.logFileField.getText();
        System.out.println("Changing log file to " + string);
        Log.getLog().setFilename(string);
    }

    public Insets getInsets() {
        return this.insets;
    }

    private GridBagConstraints constraints(int n, int n2, int n3, int n4) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        return gridBagConstraints;
    }
}

